/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class ItemUpgradeStorage
extends ItemUpgrade {
    private static final int storageGroupId = ItemUpgrade.getNextGroupId();
    public final EnumUpgradeStorage level;

    public ItemUpgradeStorage(EnumUpgradeStorage level, Item.Properties properties) {
        this(level, properties, storageGroupId);
    }

    protected ItemUpgradeStorage(EnumUpgradeStorage level, Item.Properties properties, int groupId) {
        super(properties, groupId);
        this.setAllowMultiple(true);
        this.level = level;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableStorageUpgrade.get();
    }

    @Override
    @NotNull
    public Component getDescription() {
        if (!this.isEnabled()) {
            return super.getDescription();
        }
        int mult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(this.level.getLevel());
        return Component.translatable((String)"item.storagedrawers.storage_upgrade.desc", (Object[])new Object[]{mult});
    }
}

